<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('attachments', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('image', 'video', 'doc'));
			$table->integer('model_id')->unsigned();
			$table->string('model_type');
			$table->string('path');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('attachments');
	}
}