<?php

namespace App;

class Institution extends Eloquent {

	protected $table = 'institutions';
	public $timestamps = true;
	protected $fillable = array('id_type', 'id_professionnels', 'name', 'phone1', 'phone2', 'email', 'owner_id');
	protected $visible = array('id_type', 'id_professionnels', 'name', 'phone1', 'phone2', 'email', 'owner_id');

	public function professionnel()
	{
		return $this->belongsTo('App\Professionnel', 'id_proffessionnel');
	}

	public function type()
	{
		return $this->belongsTo('App\Type', 'id_type');
	}

	public function adresse()
	{
		return $this->hasMany('App\Adresse', 'id_intitution');
	}

	public function hour()
	{
		return $this->hasMany('App\Hour', 'id_intitution');
	}

	public function employee()
	{
		return $this->hasMany('App\Employee', 'id_intitution');
	}

	public function activity_institution()
	{
		return $this->hasMany('App\Activity_institution', 'id_intitution');
	}

}