<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('PaymentTransactions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('booking_id')->unsigned();
			$table->string('transaction_id');
			$table->decimal('amount');
			$table->enum('payment_status', array('pending', 'completed', 'failed'));
		});
	}

	public function down()
	{
		Schema::drop('PaymentTransactions');
	}
}