<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200);
			$table->string('email', 200)->unique();
			$table->string('password');
			$table->string('password_confirmation');
			$table->enum('type', array('admin', 'user', 'consultant'));
			$table->boolean('status');
			$table->timestamps();
			$table->string('image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}