<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('tickets_count')->unsigned();
			$table->string('note')->nullable();
			$table->integer('location_id')->unsigned();
			$table->integer('event_id')->unsigned();
			$table->smallInteger('payment_type');
			$table->smallInteger('status');
			$table->decimal('price', 10,10);
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}