<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkflowTable extends Migration {

	public function up()
	{
		Schema::create('workflow', function(Blueprint $table) {
			$table->increments('id');
			$table->json('title');
			$table->bigInteger('user_id')->unsigned();
			$table->boolean('final_action')->default(0);
			$table->mediumInteger('sort')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('workflow');
	}
}