<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->string('email');
			$table->string('password')->nullable();
			$table->string('country')->nullable();
			$table->enum('Type', array('male', 'female'));
			$table->date('date_birth')->nullable();
			$table->string('type_study')->nullable();
			$table->string('brief')->nullable();
			$table->string('image')->nullable();
			$table->string('degree')->nullable();
			$table->enum('user_role', array('1', '2', '3'));
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}