<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('books', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('books', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('books_favorite', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('books_favorite', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('books_favorite', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('favorite_departments')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('categories_parents', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('categories_parents', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('favorite_departments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_created_by_foreign');
		});
		Schema::table('books', function(Blueprint $table) {
			$table->dropForeign('books_author_id_foreign');
		});
		Schema::table('books', function(Blueprint $table) {
			$table->dropForeign('books_category_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('books_favorite', function(Blueprint $table) {
			$table->dropForeign('books_favorite_user_id_foreign');
		});
		Schema::table('books_favorite', function(Blueprint $table) {
			$table->dropForeign('books_favorite_book_id_foreign');
		});
		Schema::table('books_favorite', function(Blueprint $table) {
			$table->dropForeign('books_favorite_department_id_foreign');
		});
		Schema::table('categories_parents', function(Blueprint $table) {
			$table->dropForeign('categories_parents_category_id_foreign');
		});
		Schema::table('categories_parents', function(Blueprint $table) {
			$table->dropForeign('categories_parents_created_by_foreign');
		});
		Schema::table('favorite_departments', function(Blueprint $table) {
			$table->dropForeign('favorite_departments_user_id_foreign');
		});
	}
}