<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Comment extends Eloquent {

	protected $table = 'comments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('comment', 'user_id', 'rate');

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'user_id');
	}

}