<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('accessories', function(Blueprint $table) {
			$table->foreign('accessories_store_id')->references('id')->on('accessories_stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('accessory_store_purchases', function(Blueprint $table) {
			$table->foreign('accessories_store_id')->references('id')->on('accessories_stores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('accessory_store_purchases', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('accessory_store_purchase_accessories', function(Blueprint $table) {
			$table->foreign('accessory_store_purchase_id')->references('id')->on('accessory_store_purchases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('accessory_store_purchase_accessories', function(Blueprint $table) {
			$table->foreign('accessory_id')->references('id')->on('accessories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('accessories', function(Blueprint $table) {
			$table->dropForeign('accessories_accessories_store_id_foreign');
		});
		Schema::table('accessory_store_purchases', function(Blueprint $table) {
			$table->dropForeign('accessory_store_purchases_accessories_store_id_foreign');
		});
		Schema::table('accessory_store_purchases', function(Blueprint $table) {
			$table->dropForeign('accessory_store_purchases_user_id_foreign');
		});
		Schema::table('accessory_store_purchase_accessories', function(Blueprint $table) {
			$table->dropForeign('accessory_store_purchase_accessories_accessory_store_purchase_id_foreign');
		});
		Schema::table('accessory_store_purchase_accessories', function(Blueprint $table) {
			$table->dropForeign('accessory_store_purchase_accessories_accessory_id_foreign');
		});
	}
}