<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('veron_id');
			$table->integer('company_id');
			$table->integer('role_id')->default('0');
			$table->string('username')->nullable();
			$table->string('name', 191);
			$table->string('email', 191)->unique();
			$table->text('password');
			$table->text('remember_token');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}