<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('veron_id', 'company_id', 'name', 'detail', 'version', 'live_url', 'test_url', 'html_url');
    protected $visible = array('veron_id', 'company_id', 'name', 'detail', 'version', 'live_url', 'test_url', 'html_url');

    public function tasks()
    {
        return $this->hasMany('Ticket');
    }

    public function company()
    {
        return $this->belongsTo('Company');
    }

    public function contracts()
    {
        return $this->hasMany('Contract');
    }

}