<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('owner_user_id')->unsigned();
			$table->integer('institute_id')->unsigned();
			$table->integer('project_status_id')->unsigned();
			$table->integer('sub_status_id')->unsigned()->nullable();
			$table->integer('project_type_id')->unsigned()->nullable();
			$table->integer('prev_project_id')->unsigned()->nullable();
			$table->string('name')->nullable();
			$table->text('description')->nullable();
			$table->string('construction_code')->nullable();
			$table->boolean('consortium')->nullable();
			$table->string('indicator')->nullable();
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
			$table->bigInteger('contribution')->unsigned()->nullable();
			$table->bigInteger('own_funds')->unsigned()->nullable();
			$table->boolean('support')->nullable();
			$table->text('remark')->nullable();
			$table->string('project_number')->nullable();
			$table->boolean('project_closed')->nullable();
			$table->boolean('financial_closed')->nullable();
			$table->date('contract_document_deadline')->nullable();
			$table->bigInteger('granted_contribution')->unsigned()->nullable();
			$table->date('preparing_start_date')->nullable();
			$table->date('preparing_end_date')->nullable();
			$table->datetime('last_updated_at')->nullable();
			$table->date('financial_close_date')->nullable();
			$table->date('project_close_date')->nullable();
			$table->date('holding_start_date')->nullable();
			$table->date('holding_end_date')->nullable();
			$table->date('pledge_start_date')->nullable();
			$table->date('pledge_end_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}