<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('full_name', 255);
			$table->string('username', 255);
			$table->string('password', 600);
			$table->integer('user_group_id')->unsigned();
			$table->rememberToken();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}