<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user_group()
	{
		return $this->belongsTo('User_group', 'user_group_id');
	}

	public function group()
	{
		return $this->hasMany('User_group', 'user_id');
	}

	public function update_log()
	{
		return $this->hasMany('App\Models\Log', 'user_id');
	}

}