<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Tags', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('Roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Product_Tag', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Product_Tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('Tags')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Files', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Files', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('Files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('File_Product', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('Files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('File_Product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Company', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Products_user_id_foreign');
		});
		Schema::table('Tags', function(Blueprint $table) {
			$table->dropForeign('Tags_user_id_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_role_id_foreign');
		});
		Schema::table('Product_Tag', function(Blueprint $table) {
			$table->dropForeign('Product_Tag_product_id_foreign');
		});
		Schema::table('Product_Tag', function(Blueprint $table) {
			$table->dropForeign('Product_Tag_tag_id_foreign');
		});
		Schema::table('Files', function(Blueprint $table) {
			$table->dropForeign('Files_user_id_foreign');
		});
		Schema::table('Files', function(Blueprint $table) {
			$table->dropForeign('Files_parent_id_foreign');
		});
		Schema::table('File_Product', function(Blueprint $table) {
			$table->dropForeign('File_Product_file_id_foreign');
		});
		Schema::table('File_Product', function(Blueprint $table) {
			$table->dropForeign('File_Product_product_id_foreign');
		});
		Schema::table('Company', function(Blueprint $table) {
			$table->dropForeign('Company_user_id_foreign');
		});
	}
}