<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpertsTable extends Migration {

	public function up()
	{
		Schema::create('experts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 255);
			$table->string('last_name')->nullable();
			$table->string('email');
			$table->string('avatar');
			$table->text('description')->nullable();
			$table->text('short_description')->nullable();
			$table->string('record_voice')->nullable();
			$table->boolean('sexe');
			$table->string('code_tva')->nullable();
			$table->string('pseudo');
			$table->string('adress')->nullable();
			$table->string('zip_code');
			$table->string('ville');
			$table->enum('new', array(''));
			$table->string('mobile');
			$table->string('phone_fix');
			$table->string('code')->unique();
		});
	}

	public function down()
	{
		Schema::drop('experts');
	}
}