<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('consultant_categorie', function(Blueprint $table) {
			$table->foreign('consultant_id')->references('id')->on('experts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultant_categorie', function(Blueprint $table) {
			$table->foreign('categorie_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workhours', function(Blueprint $table) {
			$table->foreign('day_id')->references('id')->on('days')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workhours', function(Blueprint $table) {
			$table->foreign('consultant_id')->references('id')->on('experts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('consultant_id')->references('id')->on('experts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('experts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultants_languages', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultants_languages', function(Blueprint $table) {
			$table->foreign('consultant_id')->references('id')->on('experts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultants_communications', function(Blueprint $table) {
			$table->foreign('consultant_id')->references('id')->on('experts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultants_communications', function(Blueprint $table) {
			$table->foreign('communication_id')->references('id')->on('communications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('countrie_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('newsletters', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('favoris', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('favoris', function(Blueprint $table) {
			$table->foreign('consultant_id')->references('id')->on('experts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('consultant_categorie', function(Blueprint $table) {
			$table->dropForeign('consultant_categorie_consultant_id_foreign');
		});
		Schema::table('consultant_categorie', function(Blueprint $table) {
			$table->dropForeign('consultant_categorie_categorie_id_foreign');
		});
		Schema::table('workhours', function(Blueprint $table) {
			$table->dropForeign('workhours_day_id_foreign');
		});
		Schema::table('workhours', function(Blueprint $table) {
			$table->dropForeign('workhours_consultant_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_consultant_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('consultants_languages', function(Blueprint $table) {
			$table->dropForeign('consultants_languages_language_id_foreign');
		});
		Schema::table('consultants_languages', function(Blueprint $table) {
			$table->dropForeign('consultants_languages_consultant_id_foreign');
		});
		Schema::table('consultants_communications', function(Blueprint $table) {
			$table->dropForeign('consultants_communications_consultant_id_foreign');
		});
		Schema::table('consultants_communications', function(Blueprint $table) {
			$table->dropForeign('consultants_communications_communication_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_countrie_id_foreign');
		});
		Schema::table('newsletters', function(Blueprint $table) {
			$table->dropForeign('newsletters_user_id_foreign');
		});
		Schema::table('favoris', function(Blueprint $table) {
			$table->dropForeign('favoris_user_id_foreign');
		});
		Schema::table('favoris', function(Blueprint $table) {
			$table->dropForeign('favoris_consultant_id_foreign');
		});
	}
}