<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePenaltyTable extends Migration {

	public function up()
	{
		Schema::create('penalty', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('title');
			$table->timestamps();
			$table->softDeletes();
			$table->double('value');
			$table->boolean('static_value')->default(FALSE);
			$table->enum('type', array('Day', 'Month', 'Year'));
		});
	}

	public function down()
	{
		Schema::drop('penalty');
	}
}