<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExperimentTable extends Migration {

	public function up()
	{
		Schema::create('Experiment', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('participants_sql');
			$table->enum('state', array('draft', 'scheduled', 'active', 'paused', 'aborted', 'completed'));
			$table->datetimeTz('start_datetime')->nullable();
			$table->string('end_datetime')->nullable();
			$table->string('name');
			$table->json('strata');
			$table->string('description');
			$table->json('experiment_config');
		});
	}

	public function down()
	{
		Schema::drop('Experiment');
	}
}