<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImportExportJobsTable extends Migration {

	public function up()
	{
		Schema::create('import_export_jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned()->index();
			$table->string('plate', 12)->nullable();
			$table->string('mercancy')->nullable();
			$table->string('chofer')->nullable();
			$table->string('parking', 5)->nullable();
			$table->tinyInteger('controlled')->default('0');
			$table->tinyInteger('circuit')->index()->default('0');
			$table->text('notes')->nullable();
			$table->timestamps();
			$table->string('morph_type');
			$table->integer('morph_id');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('import_export_jobs');
	}
}