<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('astrologer_id')->unsigned();
			$table->datetime('start_at');
			$table->datetime('end_at');
			$table->boolean('chat_availability');
			$table->boolean('call_availability');
			$table->boolean('video_availability');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('schedules');
	}
}