<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'password', 'phone', 'type', 'city_id');

	public function jobs()
	{
		return $this->hasMany('Job');
	}

	public function applications()
	{
		return $this->hasMany('Application');
	}

	public function notifications()
	{
		return $this->hasMany('Notification');
	}

	public function categories()
	{
		return $this->belongsToMany('Category');
	}

}