<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Global extends Eloquent {

	protected $table = 'globals';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'desc', 'phone', 'website', 'country_id');

	public function photos()
	{
		return $this->morphMany('Photo');
	}

}