<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCaseGuarantorsTable extends Migration {

	public function up()
	{
		Schema::create('case_guarantors', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('case_id')->unsigned();
			$table->string('name', 255);
			$table->enum('Identity_type', array(''));
			$table->string('Identity_number', 255);
			$table->string('nationality');
			$table->text('home_address')->nullable();
			$table->text('work_address')->nullable();
			$table->string('home_phone', 255)->nullable();
			$table->string('work_phone', 255)->nullable();
			$table->string('job', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('case_guarantors');
	}
}