<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientProceduresTable extends Migration {

	public function up()
	{
		Schema::create('client_procedures', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id')->unsigned();
			$table->enum('type', array('contract', 'greeting', 'exit'));
			$table->text('statement');
			$table->date('decision_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('client_procedures');
	}
}