<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpenseTypesTable extends Migration {

	public function up()
	{
		Schema::create('expense_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_en', 255);
			$table->string('name_ar', 255);
			$table->decimal('amount', 8,2);
			$table->enum('type', array('judicial', 'sundries'));
			$table->timestamp('timestamps');
		});
	}

	public function down()
	{
		Schema::drop('expense_types');
	}
}