<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalCasesTable extends Migration {

	public function up()
	{
		Schema::create('legal_cases', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id')->unsigned()->nullable();
			$table->bigInteger('case_type_id')->unsigned()->nullable();
			$table->string('client_name', 255);
			$table->string('opponent_name', 255);
			$table->string('subject', 255);
			$table->string('case_reference_number', 255)->nullable();
			$table->string('number_1', 255)->nullable();
			$table->string('number_2', 255)->nullable();
			$table->string('number_3', 255)->nullable();
			$table->date('date_of_receipt');
			$table->date('closing_date')->nullable();
			$table->integer('police_station_number')->nullable();
			$table->string('police_station_name', 255)->nullable();
			$table->enum('case_level', array('primary', 'appeal', 'cassation'));
			$table->bigInteger('case_status_id')->unsigned()->nullable();
			$table->smallInteger('floor')->nullable();
			$table->string('courtroom', 255)->nullable();
			$table->boolean('notification_status')->nullable();
			$table->text('notes')->nullable();
			$table->boolean('confidentiality_status')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('legal_cases');
	}
}