<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('client_attachments', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_procedures', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('legal_cases', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('legal_cases', function(Blueprint $table) {
			$table->foreign('case_type_id')->references('id')->on('basic_data')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('legal_cases', function(Blueprint $table) {
			$table->foreign('case_status_id')->references('id')->on('basic_data')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('case_opponents', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('legal_cases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_guarantors', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('legal_cases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_users', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('legal_cases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('legal_cases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_levels', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('client_attachments', function(Blueprint $table) {
			$table->dropForeign('client_attachments_client_id_foreign');
		});
		Schema::table('client_procedures', function(Blueprint $table) {
			$table->dropForeign('client_procedures_client_id_foreign');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->dropForeign('bank_accounts_bank_id_foreign');
		});
		Schema::table('legal_cases', function(Blueprint $table) {
			$table->dropForeign('legal_cases_client_id_foreign');
		});
		Schema::table('legal_cases', function(Blueprint $table) {
			$table->dropForeign('legal_cases_case_type_id_foreign');
		});
		Schema::table('legal_cases', function(Blueprint $table) {
			$table->dropForeign('legal_cases_case_status_id_foreign');
		});
		Schema::table('case_opponents', function(Blueprint $table) {
			$table->dropForeign('case_opponents_case_id_foreign');
		});
		Schema::table('case_guarantors', function(Blueprint $table) {
			$table->dropForeign('case_guarantors_case_id_foreign');
		});
		Schema::table('case_users', function(Blueprint $table) {
			$table->dropForeign('case_users_case_id_foreign');
		});
		Schema::table('case_users', function(Blueprint $table) {
			$table->dropForeign('case_users_user_id_foreign');
		});
		Schema::table('case_levels', function(Blueprint $table) {
			$table->dropForeign('case_levels_case_id_foreign');
		});
	}
}