<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CartItem extends Model 
{

    protected $table = 'cart_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('sub_total', 'discount', 'total', 'tax');

    public function cart()
    {
        return $this->belongsTo('Cart');
    }

}