<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigIncrements('company_id');
			$table->bigIncrements('user_id');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email');
			$table->string('password');
			$table->enum('status', array('active', 'passive'));
			$table->timestamp('last_login_at');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}