<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Cart extends Eloquent {

	protected $table = 'carts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('office_associate_id', 'sub_total', 'discount', 'total', 'note');

	public function items()
	{
		return $this->hasMany('CartItem');
	}

}