<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'sub_total', 'cart_id', 'discount', 'total', 'note');

	public function items()
	{
		return $this->hasMany('OrderItem');
	}

	public function payment()
	{
		return $this->hasOne('OrderPayment');
	}

	public function invoice()
	{
		return $this->hasOne('Invoice');
	}

}