<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('office_associate_id')->nullable();
			$table->integer('order_id');
			$table->integer('user_id')->unsigned();
			$table->string('currency');
			$table->string('receiver_email');
			$table->string('ettn');
			$table->string('status');
			$table->string('pdf');
			$table->string('send_status');
			$table->string('print_status');
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}