<?php

namespace Order;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Orders extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function orderType()
	{
		return $this->hasOne('OrderType');
	}

	public function getProduct()
	{
		return $this->hasOne('Products');
	}

	public function getUser()
	{
		return $this->hasOne('Users');
	}

}