<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlidersTable extends Migration {

	public function up()
	{
		Schema::create('sliders', function(Blueprint $table) {
			$table->increments('id');
			$table->text('desktop_img')->nullable();
			$table->text('mobile_img')->nullable();
			$table->string('slider_title', 255)->nullable();
			$table->string('slider_url', 255)->nullable();
			$table->string('is_active', 255)->nullable()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sliders');
	}
}