<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonalAccessTokensTable extends Migration {

	public function up()
	{
		Schema::create('personal_access_tokens', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id');
			$table->string('name');
			$table->string('token');
			$table->text('abilities');
			$table->timestamp('last_used_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('personal_access_tokens');
	}
}