<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->char('name', 191);
			$table->string('email', 191)->unique();
			$table->string('password', 191);
			$table->string('token', 191);
			$table->boolean('verifyed')->nullable()->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}