<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAirportsTable extends Migration {

	public function up()
	{
		Schema::create('airports', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->string('name')->nullable();
			$table->string('iata')->unique()->nullable();
			$table->string('icao')->unique()->nullable();
			$table->decimal('latitude', 10,7)->nullable();
			$table->decimal('longitude', 10,7)->nullable();
			$table->integer('city_id')->nullable();
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('airports');
	}
}