<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePassportsTable extends Migration {

	public function up()
	{
		Schema::create('passports', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('document_id')->unsigned();
			$table->string('passport_number');
			$table->date('issue_at')->nullable();
			$table->date('expiry_at')->nullable();
			$table->bigInteger('nationality_country_id')->unsigned();
			$table->string('given_name')->nullable();
			$table->string('surname')->nullable();
			$table->string('place_of_issue')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('passports');
	}
}