<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCountriesTable extends Migration {

	public function up()
	{
		Schema::create('user_countries', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->enum('type', array('VISITED', 'WISHLIST'));
			$table->bigInteger('country_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('user_countries');
	}
}