<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlightsTable extends Migration {

	public function up()
	{
		Schema::create('flights', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->string('iata');
			$table->string('icao');
			$table->integer('to_airport_id')->unsigned()->nullable();
			$table->integer('from_airport_id')->unsigned()->nullable();
			$table->integer('airline_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('flights');
	}
}