<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlightSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('flight_schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->datetime('departure_at');
			$table->datetime('arrival_at');
			$table->string('status');
			$table->string('departure_terminal')->nullable();
			$table->string('arrival_terminal')->nullable();
			$table->bigInteger('flight_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('flight_schedules');
	}
}