<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email');
			$table->string('password', 255);
			$table->string('phone', 255)->nullable();
			$table->string('address', 255)->nullable();
			$table->string('longitude', 255)->nullable();
			$table->string('latitude', 255)->nullable();
			$table->integer('academic_year_id')->unsigned()->nullable();
			$table->string('profile_image', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}