<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration {

	public function up()
	{
		Schema::create('lessons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('teacher_id')->unsigned();
			$table->decimal('price')->nullable()->default('0.0');
			$table->string('name', 255);
			$table->integer('type')->default('1');
			$table->string('description', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('lessons');
	}
}