<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfileToProfessionalGroupsToLeadershipRolesTable extends Migration {

	public function up()
	{
		Schema::create('profile_to_professional_groups_to_leadership_roles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('profile_id')->unsigned()->index();
			$table->integer('profile_to_professional_group_id')->unsigned()->index();
			$table->string('year')->nullable();
			$table->integer('address_id')->unsigned()->index();
			$table->string('role');
			$table->integer('creator')->unsigned()->index();
			$table->integer('created_at')->unsigned();
			$table->integer('updated_at')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('profile_to_professional_groups_to_leadership_roles');
	}
}