<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('consultant_profiles', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultant_profiles', function(Blueprint $table) {
			$table->foreign('hcp_profile')->references('id')->on('hcp_profile')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultant_profiles', function(Blueprint $table) {
			$table->foreign('primary_address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('speaker_profile', function(Blueprint $table) {
			$table->foreign('consultant_profile')->references('id')->on('consultant_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('publications', function(Blueprint $table) {
			$table->foreign('publication_type_id')->references('id')->on('publication_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('publications', function(Blueprint $table) {
			$table->foreign('profile_experience_id')->references('id')->on('profile_experience')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profile_to_publications', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profile_to_publications', function(Blueprint $table) {
			$table->foreign('publication_id')->references('id')->on('publications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('consultant_profiles', function(Blueprint $table) {
			$table->dropForeign('consultant_profiles_profile_id_foreign');
		});
		Schema::table('consultant_profiles', function(Blueprint $table) {
			$table->dropForeign('consultant_profiles_hcp_profile_foreign');
		});
		Schema::table('consultant_profiles', function(Blueprint $table) {
			$table->dropForeign('consultant_profiles_primary_address_id_foreign');
		});
		Schema::table('speaker_profile', function(Blueprint $table) {
			$table->dropForeign('speaker_profile_consultant_profile_foreign');
		});
		Schema::table('publications', function(Blueprint $table) {
			$table->dropForeign('publications_publication_type_id_foreign');
		});
		Schema::table('publications', function(Blueprint $table) {
			$table->dropForeign('publications_profile_experience_id_foreign');
		});
		Schema::table('profile_to_publications', function(Blueprint $table) {
			$table->dropForeign('profile_to_publications_profile_id_foreign');
		});
		Schema::table('profile_to_publications', function(Blueprint $table) {
			$table->dropForeign('profile_to_publications_publication_id_foreign');
		});
	}
}