<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Caddies extends Model 
{

    protected $table = 'caddies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function platform()
    {
        return $this->hasOne('Platforms');
    }

    public function dimension()
    {
        return $this->hasOne('Dimensions');
    }

}