<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCaddiesTable extends Migration {

	public function up()
	{
		Schema::create('caddies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->default('filename');
			$table->integer('user_id')->unsigned();
			$table->integer('platform')->unsigned();
			$table->integer('dimension')->unsigned();
			$table->json('raw_data')->nullable();
			$table->json('lab_data');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('caddies');
	}
}