<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractsTable extends Migration {

	public function up()
	{
		Schema::create('contracts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->integer('contractor_id');
			$table->integer('realty_id');
			$table->integer('unit_id');
			$table->integer('period');
			$table->integer('period_durations');
			$table->double('value');
			$table->integer('value_durations');
			$table->enum('update', array('yes', 'no', ''));
			$table->datetime('start_at');
			$table->integer('contract_status');
			$table->datetime('expire_at');
			$table->datetime('next_payments');
			$table->integer('days');
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contracts');
	}
}